USE [Elerium]
GO

/****** Object:  Table [dbo].[RewardUser]    Script Date: 10/23/2013 1:02:40 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[RewardUser](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[HasProvided1099] [bit] NOT NULL,
	[IsBannedOnLegacyCF] [bit] NOT NULL,
	[IsBlacklisted] [bit] NOT NULL,
	[IsBlockedFromUsingPoints] [bit] NOT NULL,
	[IsEmployee] [bit] NOT NULL,
	[IsEnrolled] [bit] NOT NULL,
	[LastLoginOnLegacyCF] [datetime] NULL,
 CONSTRAINT [PK_RewardUser] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[RewardUser] ADD  CONSTRAINT [DF_RewardUser_HasProvided1099]  DEFAULT ((0)) FOR [HasProvided1099]
GO

ALTER TABLE [dbo].[RewardUser] ADD  CONSTRAINT [DF_RewardUser_IsBannedOnCurseForge]  DEFAULT ((0)) FOR [IsBannedOnLegacyCF]
GO

ALTER TABLE [dbo].[RewardUser] ADD  CONSTRAINT [DF_RewardUser_IsBlacklisted]  DEFAULT ((0)) FOR [IsBlacklisted]
GO

ALTER TABLE [dbo].[RewardUser] ADD  CONSTRAINT [DF_RewardUser_IsBlockedFromUsingPoints]  DEFAULT ((0)) FOR [IsBlockedFromUsingPoints]
GO

ALTER TABLE [dbo].[RewardUser] ADD  CONSTRAINT [DF_RewardUser_IsEmployee]  DEFAULT ((0)) FOR [IsEmployee]
GO

ALTER TABLE [dbo].[RewardUser] ADD  CONSTRAINT [DF_RewardUser_IsEnrolled]  DEFAULT ((0)) FOR [IsEnrolled]
GO

ALTER TABLE [dbo].[RewardUser]  WITH CHECK ADD  CONSTRAINT [FK_RewardUser_User] FOREIGN KEY([UserID])
REFERENCES [dbo].[User] ([ID])
GO

ALTER TABLE [dbo].[RewardUser] CHECK CONSTRAINT [FK_RewardUser_User]
GO


